import{state as checkoutState,dispose as disposeCheckout}from"../../checkout";import{availableManualPaymentMethods,availableMethodChoices,availableMethodTypes,availableProcessorChoices,availableProcessors,getAvailableProcessor,hasMultipleMethodChoices,hasMultipleProcessorChoices,hasOtherAvailableCreditCardProcessor}from"../getters";import{state as processorsState,dispose as disposeProcessors}from"../index";import{state as selectedProcessor}from"../../selected-processor/index";describe("Processors store",(()=>{beforeEach((()=>{disposeCheckout(),disposeProcessors()})),describe("getters",(()=>{describe("availableProcessors",(()=>{it("returns all processors if no checkout",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],expect(availableProcessors()).toEqual(processorsState.processors)})),it("filters processors by mode",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],checkoutState.formId=1,checkoutState.mode="test",expect(availableProcessors()).toEqual([]),processorsState.processors=[{live_mode:!1,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!0,processor_type:"paypal"}],expect(availableProcessors()).toEqual([{live_mode:!1,recurring_enabled:!0,processor_type:"stripe"}])})),it("filters processors by recurring",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],checkoutState.formId=2,checkoutState.mode="live",checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!0},expect(availableProcessors()).toEqual([{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"}])})),it("sorts processors by sort order",(()=>{processorsState.sortOrder.processors=["paypal","stripe"],processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],expect(availableProcessors()).toEqual([{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"},{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"}])}))})),describe("getAvailableProcessor",(()=>{it("gets the processor only if it is available",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],checkoutState.formId=1,checkoutState.mode="test",expect(getAvailableProcessor("stripe")).toEqual(void 0),processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],checkoutState.formId=1,checkoutState.mode="live",expect(getAvailableProcessor("stripe")).toEqual({live_mode:!0,recurring_enabled:!0,processor_type:"stripe"})}))})),describe("hasOtherAvailableCreditCardProcessor",(()=>{it("should return true when there is another available credit card processor",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!0,processor_type:"paystack"},{live_mode:!0,recurring_enabled:!0,processor_type:"paypal"}];const e=hasOtherAvailableCreditCardProcessor("stripe");expect(e).toEqual(!0)})),it("should return undefined when there are no other available credit card processors",(()=>{const e=hasOtherAvailableCreditCardProcessor("paypal");expect(e).toBe(!1)}))})),describe("availableManualPaymentMethods",(()=>{it("is empty if reusable payment method is required",(()=>{processorsState.manualPaymentMethods=[{id:"test1",name:"Test 1",description:"Test 1"},{id:"test1",name:"Test 2",description:"Test 2"}],checkoutState.formId=2,checkoutState.mode="live",checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!0},expect(availableManualPaymentMethods()).toEqual([])})),it("gets all manual methods if recurring is not required",(()=>{processorsState.manualPaymentMethods=[{id:"test1",name:"Test 1",description:"Test 1"},{id:"test1",name:"Test 2",description:"Test 2"}],checkoutState.formId=2,checkoutState.mode="live",checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!1},expect(availableManualPaymentMethods()).toEqual(processorsState.manualPaymentMethods)}))})),describe("availableMethodTypes",(()=>{it("shows credit card, then paypal by default",(()=>{processorsState.methods=[{id:"ideal",description:"Test 1"},{id:"paypal",description:"Test 1"},{id:"creditcard",description:"Test 2"}],expect(availableMethodTypes()).toEqual([{id:"creditcard",description:"Test 2"},{id:"paypal",description:"Test 1"},{id:"ideal",description:"Test 1"}])})),it("can have a custom order",(()=>{processorsState.methods=[{id:"ideal",description:"Test 1"},{id:"paypal",description:"Test 1"},{id:"creditcard",description:"Test 2"}],processorsState.sortOrder.paymentMethods.mollie=["ideal","paypal","creditcard"],expect(availableMethodTypes()).toEqual([{id:"ideal",description:"Test 1"},{id:"paypal",description:"Test 1"},{id:"creditcard",description:"Test 2"}])}))})),describe("availableProcessorChoices, hasMultipleProcessorChoices",(()=>{it("shows both available processors and available payment methods",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],processorsState.manualPaymentMethods=[{id:"test1",name:"Test 1",description:"Test 1"},{id:"test1",name:"Test 2",description:"Test 2"}],checkoutState.formId=2,checkoutState.mode="live",checkoutState.checkout={live_mode:!0},expect(availableProcessorChoices()).toEqual([...processorsState.processors,...processorsState.manualPaymentMethods]),expect(hasMultipleProcessorChoices()).toBeTruthy(),checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!0},expect(availableProcessorChoices()).toEqual([{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"}]),expect(hasMultipleProcessorChoices()).toBeFalsy()}))})),describe("availableMethodChoices, hasMultipleMethodChoices",(()=>{it("shows both available processors and available payment methods",(()=>{processorsState.methods=[{id:"creditcard",description:"Test 2"}],processorsState.manualPaymentMethods=[{id:"test1",name:"Test 1",description:"Test 1"},{id:"test1",name:"Test 2",description:"Test 2"}],checkoutState.formId=2,checkoutState.mode="live",checkoutState.checkout={live_mode:!0},expect(availableMethodChoices()).toEqual([...processorsState.methods,...processorsState.manualPaymentMethods]),expect(hasMultipleMethodChoices()).toBeTruthy(),checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!0},expect(availableMethodChoices()).toEqual([{id:"creditcard",description:"Test 2"}]),expect(hasMultipleProcessorChoices()).toBeFalsy()}))}))})),describe("watchers",(()=>{it.skip("changes the selected processor if it is not available",(()=>{processorsState.processors=[{live_mode:!0,recurring_enabled:!0,processor_type:"stripe"},{live_mode:!0,recurring_enabled:!1,processor_type:"paypal"}],processorsState.manualPaymentMethods=[{id:"test1",name:"Test 1",description:"Test 1"},{id:"test2",name:"Test 2",description:"Test 2"}],selectedProcessor.id="test1",expect(selectedProcessor.id).toBe("test1"),checkoutState.formId=2,checkoutState.mode="live",checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!0},expect(selectedProcessor.id).toBe("stripe"),checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!1},selectedProcessor.id="test2",expect(selectedProcessor.id).toBe("test2"),checkoutState.checkout={live_mode:!0,reusable_payment_method_required:!0,amount_due:1e3},expect(selectedProcessor.id).toBe("stripe")}))}))}));